package gov.va.genisis2Test.vo;

import java.util.Date;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.vo.RequestHistory;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;

/**
 * 
 * @author1 Janet Lopez
 * 
 * The Class RequestHistoryTest.
 * 
 * Description: In this RequestHistoryTest Class which extends the abstract
 * class, AbstractMockMvcTests, junit tests are defined.
 * 
 */
public class RequestHistoryTest extends AbstractMockMvcTests {
	
	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(RequestHistoryTest.class);

	/**
	 * Test request history.
	 */
	@Test
	public void TestRequestHistory() {
		logger.info("**********Junit Test Request History**********");
		
		RequestHistory requestHistory = new RequestHistory();
		
		Assert.assertNull(requestHistory.getCommentHistory());
		Assert.assertNull(requestHistory.getCreatedBy());
		Assert.assertNull(requestHistory.getModifiedBy());
		Assert.assertNull(requestHistory.getStatusDescription());
		Assert.assertNull(requestHistory.getTitle());
		Assert.assertNull(requestHistory.getDescription());
		Assert.assertNull(requestHistory.getCreatedOn());
		Assert.assertNull(requestHistory.getModifiedOn());
		Assert.assertNull(requestHistory.getCommentHistory());
		
		requestHistory.setCreatedOn(new Date());
		requestHistory.setCreatedBy("createdBy");
		requestHistory.setDescription("description");
		requestHistory.setModifiedOn(new Date());
		requestHistory.setModifiedBy("modifiedBy");
		requestHistory.setStatusDescription("statusDescription");
		requestHistory.setTitle("title");
		requestHistory.setCommentHistory(null);
		
		Assert.assertEquals("createdBy", requestHistory.getCreatedBy());
		Assert.assertEquals("modifiedBy", requestHistory.getModifiedBy());
		Assert.assertEquals("statusDescription", requestHistory.getStatusDescription());
		Assert.assertEquals("title", requestHistory.getTitle());
		Assert.assertEquals("description", requestHistory.getDescription());
		Assert.assertNotNull(requestHistory.getCreatedOn());
		Assert.assertNotNull(requestHistory.getModifiedOn());
		Assert.assertNull(requestHistory.getCommentHistory());

		requestHistory = new RequestHistory("titleTestOne", "descriptionTestOne",
				"statusDescriptionTestOne", new Date(), "createdByTestOne", new Date(), "modifiedByTestOne", null);

		Assert.assertEquals("createdByTestOne", requestHistory.getCreatedBy());
		Assert.assertEquals("modifiedByTestOne", requestHistory.getModifiedBy());
		Assert.assertEquals("statusDescriptionTestOne", requestHistory.getStatusDescription());
		Assert.assertEquals("titleTestOne", requestHistory.getTitle());
		Assert.assertEquals("descriptionTestOne", requestHistory.getDescription());
		Assert.assertNotNull(requestHistory.getCreatedOn());
		Assert.assertNotNull(requestHistory.getModifiedOn());
		Assert.assertNull(requestHistory.getCommentHistory());

		logger.info("**********End of Test Junit Test Request History**********");

	}

}
